#!/bin/bash

# 定义tmux会话名称
SESSION_NAME="dynamics_model"
tmux kill-session -t "$SESSION_NAME"

#"python examples/train/train_mb_cvpo.py --task 'OfflinePointButton1Gymnasium-v0' --use_mobile False --use_feasible_q False --use_bc_loss False --binary_cost_penalty False --use_hj False --device 'cuda:0' --rollout_length 1 --penalty_coef 1.0 --real_ratio 0.05"

# 定义命令列表
commands=(
    "python examples/train/train_offline_model.py --task 'OfflineAntCircle-v0' --device 'cuda:4' --simple_scaler True --safe_only True"
)

# 创建一个新的tmux会话（不附加到该会话）
tmux new-session -d -s "$SESSION_NAME"

# 遍历命令列表，在每个窗口中运行一个命令
for i in "${!commands[@]}"; do
    CMD="${commands[i]}"
    if [ "$i" -eq 0 ]; then
        # 在第一个窗口中运行命令
        tmux send-keys -t "$SESSION_NAME:0" "$CMD" C-m
        tmux rename-window -t "$SESSION_NAME:0" "task_$((i + 1))"
    else
        # 创建新的窗口并运行命令
        tmux new-window -t "$SESSION_NAME" -n "task_$((i + 1))"
        tmux send-keys -t "$SESSION_NAME:task_$((i + 1))" "$CMD" C-m
    fi
done

# 可选：附加到tmux会话查看运行状态
tmux attach-session -t "$SESSION_NAME"
